<?php
/*
Plugin Name: Cyrillic 2 Latin
Description: Translate Wordpress from (Serbian, Russian, Bullgarian, Macedonian, Ukrainian, Greek, Makedonian, Armenian, Georgian, Kazakh) cyrillic to latin
Version: 1.0
Author: Desperado House - Cvijetin Maletic
Author URI: https://desperadohouse.com/
License: GPL-2.0+
License URI: https://www.gnu.org/licenses/license-list.html#GPLv2
Text Domain:cyrillic2latin

Copyright 2024  Desperado House (email : info@desperadohouse.com)
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* SERBIAN */
if (get_locale() == 'sr_RS') {
    class CYRTOL_Srb2Lat {
	    public $serbian = array(
		    "А" => "A",
		    "Б" => "B",
		    "В" => "V",
		    "Г" => "G",
		    "Д" => "D",
		    "Ђ" => "Đ",
		    "Е" => "E",
		    "Ж" => "Ž",
		    "З" => "Z",
		    "И" => "I",
		    "Ј" => "J",
		    "К" => "K",
		    "Л" => "L",
		    "Љ" => "Lj",
		    "М" => "M",
		    "Н" => "N",
		    "Њ" => "Nj",
		    "О" => "O",
		    "П" => "P",
		    "Р" => "R",
		    "С" => "S",
		    "Т" => "T",
		    "Ћ" => "Ć",
		    "У" => "U",
		    "Ф" => "F",
		    "Х" => "H",
		    "Ц" => "C",
		    "Ч" => "Č",
		    "Џ" => "Dž",
		    "Ш" => "Š",
		    "а" => "a",
		    "б" => "b",
		    "в" => "v",
		    "г" => "g",
		    "д" => "d",
		    "ђ" => "đ",
		    "е" => "e",
		    "ж" => "ž",
		    "з" => "z",
		    "и" => "i",
		    "ј" => "j",
		    "к" => "k",
		    "л" => "l",
		    "љ" => "lj",
		    "м" => "m",
		    "н" => "n",
		    "њ" => "nj",
		    "о" => "o",
		    "п" => "p",
		    "р" => "r",
		    "с" => "s",
		    "т" => "t",
		    "ћ" => "ć",
		    "у" => "u",
		    "ф" => "f",
		    "х" => "h",
		    "ц" => "c",
		    "ч" => "č",
		    "џ" => "dž",
		    "ш" => "š",
	    );

        public function __construct() {
	        $this->CYRTOL_conversationSR();
        }

        private function CYRTOL_conversationSR() {
            $filters = [
	            'gettext',
	            'gettext_with_context',
	            'ngettext',
	            'ngettext_with_context',
            ];

            foreach ($filters as $filter) {
	            add_filter($filter, [$this, 'CYRTOL_translationSR'], 9);
            }
        }



        public function CYRTOL_translationSR( $languageSR ) {
	        return strtr( $languageSR, $this->serbian );
        }
    }

    $Srb2Lat = new CYRTOL_Srb2Lat;
}

/* RUSSIAN */
if (get_locale() == 'ru_RU') {
	class CYRTOL_Russ2Lat {
	
		public $russian = array(
			'А' => 'A',
			'Б' => 'B',
			'В' => 'V',
			'Г' => 'G',
			'Д' => 'D',
			'Е' => 'E',
			'Ё' => 'YO',
			'Ж' => 'ZH',
			'З' => 'Z',
			'И' => 'I',
			'Й' => 'J',
			'К' => 'K',
			'Л' => 'L',
			'М' => 'M',
			'Н' => 'N',
			'О' => 'O',
			'П' => 'P',
			'Р' => 'R',
			'С' => 'S',
			'Т' => 'T',
			'У' => 'U',
			'Ф' => 'F',
			'Х' => 'H',
			'Ц' => 'CZ',
			'Ч' => 'CH',
			'Ш' => 'SH',
			'Щ' => 'SHH',
			'Ъ' => '',
			'Ы' => 'Y',
			'Ь' => '',
			'Э' => 'E',
			'Ю' => 'YU',
			'Я' => 'YA',
			'а' => 'a',
			'б' => 'b',
			'в' => 'v',
			'г' => 'g',
			'д' => 'd',
			'е' => 'e',
			'ё' => 'yo',
			'ж' => 'zh',
			'з' => 'z',
			'и' => 'i',
			'й' => 'j',
			'к' => 'k',
			'л' => 'l',
			'м' => 'm',
			'н' => 'n',
			'о' => 'o',
			'п' => 'p',
			'р' => 'r',
			'с' => 's',
			'т' => 't',
			'у' => 'u',
			'ф' => 'f',
			'х' => 'h',
			'ц' => 'cz',
			'ч' => 'ch',
			'ш' => 'sh',
			'щ' => 'shh',
			'ъ' => '',
			'ы' => 'y',
			'ь' => '',
			'э' => 'e',
			'ю' => 'yu',
			'я' => 'ya',
			'І' => 'I',
			'і' => 'i',
			'Ѣ' => 'YE',
			'ѣ' => 'ye',
			'Ѳ' => 'FH',
			'ѳ' => 'fh',
			'Ѵ' => 'YH',
			'ѵ' => 'yh',
		);
	
    public function __construct() {
       $this->CYRTOL_conversationRU();
    }

private function CYRTOL_conversationRU() {
    $filters = [
        'gettext',
        'gettext_with_context',
        'ngettext',
        'ngettext_with_context',
    ];

    foreach ($filters as $filter) {
        add_filter($filter, [$this, 'CYRTOL_translationRU'], 9);
    }
}



	public function CYRTOL_translationRU( $languageRU ) {
		return strtr( $languageRU, $this->russian );
	}
	
	
	}
	$Russ2Lat = new CYRTOL_Russ2Lat;
	}
	
/* BELORUSSIAN */
if (get_locale() == 'bel') {
	class CYRTOL_BEL2Lat {
	
		public $belorussian = array(
			'А' => 'A',
			'Б' => 'B',
			'В' => 'V',
			'Г' => 'G',
			'Д' => 'D',
			'Е' => 'E',
			'Ё' => 'YO',
			'Ж' => 'ZH',
			'З' => 'Z',
			'И' => 'I',
			'Й' => 'J',
			'К' => 'K',
			'Л' => 'L',
			'М' => 'M',
			'Н' => 'N',
			'О' => 'O',
			'П' => 'P',
			'Р' => 'R',
			'С' => 'S',
			'Т' => 'T',
			'У' => 'U',
			'Ф' => 'F',
			'Х' => 'H',
			'Ц' => 'CZ',
			'Ч' => 'CH',
			'Ш' => 'SH',
			'Щ' => 'SHH',
			'Ъ' => '',
			'Ы' => 'Y',
			'Ь' => '',
			'Э' => 'E',
			'Ю' => 'YU',
			'Я' => 'YA',
			'а' => 'a',
			'б' => 'b',
			'в' => 'v',
			'г' => 'g',
			'д' => 'd',
			'е' => 'e',
			'ё' => 'yo',
			'ж' => 'zh',
			'з' => 'z',
			'и' => 'i',
			'й' => 'j',
			'к' => 'k',
			'л' => 'l',
			'м' => 'm',
			'н' => 'n',
			'о' => 'o',
			'п' => 'p',
			'р' => 'r',
			'с' => 's',
			'т' => 't',
			'у' => 'u',
			'ф' => 'f',
			'х' => 'h',
			'ц' => 'cz',
			'ч' => 'ch',
			'ш' => 'sh',
			'щ' => 'shh',
			'ъ' => '',
			'ы' => 'y',
			'ь' => '',
			'э' => 'e',
			'ю' => 'yu',
			'я' => 'ya',
			'І' => 'I',
			'і' => 'i',
			'Ѣ' => 'YE',
			'ѣ' => 'ye',
			'Ѳ' => 'FH',
			'ѳ' => 'fh',
			'Ѵ' => 'YH',
			'ѵ' => 'yh',
		);
	
		public function __construct() {
            $this->CYRTOL_conversationBEL();
        }

private function CYRTOL_conversationBEL() {
    $filters = [
        'gettext',
        'gettext_with_context',
        'ngettext',
        'ngettext_with_context',
    ];

    foreach ($filters as $filter) {
        add_filter($filter, [$this, 'CYRTOL_translationBEL'], 9);
    }
}



	public function CYRTOL_translationBEL( $languageBEL ) {
		return strtr( $languageBEL, $this->belorussian );
	}
	
	}
	$BEL2Lat = new CYRTOL_BEL2Lat;
	}
	
	/* UKRAINIAN */
if (get_locale() == 'uk') {
	class CYRTOL_UK2Lat {
	
		public $ukrainian = array(
			        'А' => 'A',
					'Б' => 'B',
					'В' => 'V',
					'Г' => 'G',
					'Ґ' => 'G',
					'Д' => 'D',
					'Е' => 'E',
					'Є' => 'YE',
					'Ж' => 'ZH',
					'З' => 'Z',
					'И' => 'Y',
					'І' => 'I',
					'Ї' => 'YI',
					'Й' => 'J',
					'К' => 'K',
					'Л' => 'L',
					'М' => 'M',
					'Н' => 'N',
					'О' => 'O',
					'П' => 'P',
					'Р' => 'R',
					'С' => 'S',
					'Т' => 'T',
					'У' => 'U',
					'Ф' => 'F',
					'Х' => 'H',
					'Ц' => 'CZ',
					'Ч' => 'CH',
					'Ш' => 'SH',
					'Щ' => 'SHH',
					'Ь' => '',
					'Ю' => 'YU',
					'Я' => 'YA',
					'а' => 'a',
					'б' => 'b',
					'в' => 'v',
					'г' => 'g',
					'ґ' => 'g',
					'д' => 'd',
					'е' => 'e',
					'є' => 'ye',
					'ж' => 'zh',
					'з' => 'z',
					'и' => 'y',
					'і' => 'i',
					'ї' => 'yi',
					'й' => 'j',
					'к' => 'k',
					'л' => 'l',
					'м' => 'm',
					'н' => 'n',
					'о' => 'o',
					'п' => 'p',
					'р' => 'r',
					'с' => 's',
					'т' => 't',
					'у' => 'u',
					'ф' => 'f',
					'х' => 'h',
					'ц' => 'cz',
					'ч' => 'ch',
					'ш' => 'sh',
					'щ' => 'shh',
					'ь' => '',
					'ю' => 'yu',
					'я' => 'ya',
		);

		public function __construct() {
            $this->CYRTOL_conversationUK();
        }

private function CYRTOL_conversationUK() {
    $filters = [
        'gettext',
        'gettext_with_context',
        'ngettext',
        'ngettext_with_context',
    ];

    foreach ($filters as $filter) {
        add_filter($filter, [$this, 'CYRTOL_translationUK'], 9);
    }
}



	public function CYRTOL_translationUK( $languageUK ) {
		return strtr( $languageUK, $this->ukrainian );
	}
	
	
	}
	$UK2Lat = new CYRTOL_UK2Lat;
	}
	
	/* BULGARIAN */
	if (get_locale() == 'bg_BG') {
		class CYRTOL_BG2Lat {
		
			public $bulgarian = array(
				'А' => 'A',
				'Б' => 'B',
				'В' => 'V',
				'Г' => 'G',
				'Д' => 'D',
				'Е' => 'E',
				'Ж' => 'ZH',
				'З' => 'Z',
				'И' => 'I',
				'Й' => 'J',
				'К' => 'K',
				'Л' => 'L',
				'М' => 'M',
				'Н' => 'N',
				'О' => 'O',
				'П' => 'P',
				'Р' => 'R',
				'С' => 'S',
				'Т' => 'T',
				'У' => 'U',
				'Ф' => 'F',
				'Х' => 'H',
				'Ц' => 'CZ',
				'Ч' => 'CH',
				'Ш' => 'SH',
				'Щ' => 'STH',
				'Ъ' => 'A',
				'Ь' => '',
				'Ю' => 'YU',
				'Я' => 'YA',
				'а' => 'a',
				'б' => 'b',
				'в' => 'v',
				'г' => 'g',
				'д' => 'd',
				'е' => 'e',
				'ж' => 'zh',
				'з' => 'z',
				'и' => 'i',
				'й' => 'j',
				'к' => 'k',
				'л' => 'l',
				'м' => 'm',
				'н' => 'n',
				'о' => 'o',
				'п' => 'p',
				'р' => 'r',
				'с' => 's',
				'т' => 't',
				'у' => 'u',
				'ф' => 'f',
				'х' => 'h',
				'ц' => 'cz',
				'ч' => 'ch',
				'ш' => 'sh',
				'щ' => 'sth',
				'ъ' => 'a',
				'ь' => '',
				'ю' => 'yu',
				'я' => 'ya',
				'І' => 'I',
				'і' => 'i',
				'Ѣ' => 'YE',
				'ѣ' => 'ye',
				'Ѫ' => 'О',
				'ѫ' => 'о',
				'Ѳ' => 'FH',
				'ѳ' => 'fh',
				'Ѵ' => 'YH',
				'ѵ' => 'yh',
			);
		
	public function __construct() {
		$this->CYRTOL_conversationBG();
	}
	
	private function CYRTOL_conversationBG() {
		$filters = [
			'gettext',
			'gettext_with_context',
			'ngettext',
			'ngettext_with_context',
		];
	
		foreach ($filters as $filter) {
			add_filter($filter, [$this, 'CYRTOL_translationBG'], 9);
		}
	}
	
	
	
		public function CYRTOL_translationBG( $languageBG ) {
			return strtr( $languageBG, $this->bulgarian );
		}
		
		
		}
		$BG2Lat = new CYRTOL_BG2Lat;
		}
			
		/* MAKEDONIAN */
	if (get_locale() == 'mk_MK') {
		class CYRTOL_MK2Lat {
		
			public $makedonian = array(
				'А' => 'A',
					'Б' => 'B',
					'В' => 'V',
					'Г' => 'G',
					'Д' => 'D',
					'Ѓ' => 'G',
					'Е' => 'E',
					'Ж' => 'ZH',
					'З' => 'Z',
					'И' => 'I',
					'Ѕ' => 'Z',
					'Ј' => 'J',
					'К' => 'K',
					'Л' => 'L',
					'Љ' => 'L',
					'М' => 'M',
					'Н' => 'N',
					'Њ' => 'N',
					'О' => 'O',
					'П' => 'P',
					'Р' => 'R',
					'С' => 'S',
					'Т' => 'T',
					'Ќ' => 'K',
					'У' => 'U',
					'Ф' => 'F',
					'Х' => 'H',
					'Ц' => 'CZ',
					'Ч' => 'CH',
					'Џ' => 'DH',
					'Ш' => 'SH',
					'а' => 'a',
					'б' => 'b',
					'в' => 'v',
					'г' => 'g',
					'д' => 'd',
					'ѓ' => 'g',
					'е' => 'e',
					'ж' => 'zh',
					'з' => 'z',
					'и' => 'i',
					'ѕ' => 'z',
					'ј' => 'j',
					'к' => 'k',
					'л' => 'l',
					'љ' => 'l',
					'м' => 'm',
					'н' => 'n',
					'њ' => 'n',
					'о' => 'o',
					'п' => 'p',
					'р' => 'r',
					'с' => 's',
					'т' => 't',
					'ќ' => 'k',
					'у' => 'u',
					'ф' => 'f',
					'х' => 'h',
					'ц' => 'cz',
					'ч' => 'ch',
					'џ' => 'dh',
					'ш' => 'sh',
			);
		
	public function __construct() {
		$this->CYRTOL_conversationMK();
		}
	
	private function CYRTOL_conversationMK() {
		$filters = [
			'gettext',
			'gettext_with_context',
			'ngettext',
			'ngettext_with_context',
		];
	
		foreach ($filters as $filter) {
			add_filter($filter, [$this, 'CYRTOL_translationMK'], 9);
		}
	}
	
	
	
		public function CYRTOL_translationMK( $languageMK ) {
			return strtr( $languageMK, $this->makedonian );
		}
		
		
		}
		$MK2Lat = new CYRTOL_MK2Lat;
		}	

		/* GREEK */
	if (get_locale() == 'el') {
		class CYRTOL_EL2Lat {
		
			public $greek = array(
				    'Α' => 'A',
					'Β' => 'B',
					'Γ' => 'G',
					'Δ' => 'D',
					'Ε' => 'E',
					'Ζ' => 'Z',
					'Η' => 'E',
					'Θ' => 'TH',
					'Ι' => 'I',
					'Κ' => 'K',
					'Λ' => 'L',
					'Μ' => 'M',
					'Ν' => 'N',
					'Ξ' => 'X',
					'Ο' => 'O',
					'Π' => 'P',
					'Ρ' => 'R',
					'Σ' => 'S',
					'Τ' => 'T',
					'Υ' => 'U',
					'Φ' => 'PH',
					'Χ' => 'KH',
					'Ψ' => 'PS',
					'Ω' => 'O',
					'α' => 'a',
					'β' => 'b',
					'γ' => 'g',
					'δ' => 'd',
					'ε' => 'e',
					'ζ' => 'z',
					'η' => 'e',
					'θ' => 'th',
					'ι' => 'i',
					'κ' => 'k',
					'λ' => 'l',
					'μ' => 'm',
					'ν' => 'n',
					'ξ' => 'x',
					'ο' => 'o',
					'π' => 'p',
					'ρ' => 'r',
					'σ' => 's',
					'ς' => 's',
					'τ' => 't',
					'υ' => 'u',
					'φ' => 'ph',
					'χ' => 'kh',
					'ψ' => 'ps',
					'ω' => 'o',
			);

			public function __construct() {
				$this->CYRTOL_conversationEL();
				}
			
			private function CYRTOL_conversationEL() {
				$filters = [
					'gettext',
					'gettext_with_context',
					'ngettext',
					'ngettext_with_context',
				];
			
				foreach ($filters as $filter) {
					add_filter($filter, [$this, 'CYRTOL_translationEL'], 9);
				}
			}
		
			function CYRTOL_translationEL ( $languageEL ) {
		
				return strtr( $languageEL, $this->greek );
		
						}
		
			function CYRTOL_EL2Lat() {
				$this->CYRTOL_conversationEL();
			}
		
		
		}
		$EL2Lat = new CYRTOL_EL2Lat;
		}	


		/* ARMENIAN */
	if (get_locale() == 'hy') {
		class CYRTOL_HY2Lat {
		
			public $armenian = array(
				    'Ա'  => 'A',
					'Բ'  => 'B',
					'Գ'  => 'G',
					'Դ'  => 'D',
					'Ե'  => 'E',
					'Զ'  => 'Z',
					'Է'  => 'E',
					'Ը'  => 'Y',
					'Թ'  => 'T',
					'Ժ'  => 'ZH',
					'Ի'  => 'I',
					'Լ'  => 'L',
					'Խ'  => 'X',
					'Ծ'  => 'C',
					'Կ'  => 'K',
					'Հ'  => 'H',
					'Ձ'  => 'J',
					'Ղ'  => 'GH',
					'Ճ'  => 'CH',
					'Մ'  => 'M',
					'Յ'  => 'Y',
					'Ն'  => 'N',
					'Շ'  => 'SH',
					'Ո'  => 'O',
					'Չ'  => 'CH',
					'Պ'  => 'P',
					'Ջ'  => 'J',
					'Ռ'  => 'RR',
					'Ս'  => 'S',
					'Վ'  => 'V',
					'Տ'  => 'T',
					'Ր'  => 'R',
					'Ց'  => 'C',
					'Ւ'  => 'W',
					'Փ'  => 'P',
					'Ք'  => 'Q',
					'Օ'  => 'O',
					'Ֆ'  => 'F',
					'ՈՒ' => 'U',
					'ա'  => 'a',
					'բ'  => 'b',
					'գ'  => 'g',
					'դ'  => 'd',
					'ե'  => 'e',
					'զ'  => 'z',
					'է'  => 'e',
					'ը'  => 'y',
					'թ'  => 't',
					'ժ'  => 'zh',
					'ի'  => 'i',
					'լ'  => 'l',
					'խ'  => 'x',
					'ծ'  => 'c',
					'կ'  => 'k',
					'հ'  => 'h',
					'ձ'  => 'j',
					'ղ'  => 'gh',
					'ճ'  => 'ch',
					'մ'  => 'm',
					'յ'  => 'y',
					'ն'  => 'n',
					'շ'  => 'sh',
					'ո'  => 'o',
					'չ'  => 'ch',
					'պ'  => 'p',
					'ջ'  => 'j',
					'ռ'  => 'rr',
					'ս'  => 's',
					'վ'  => 'v',
					'տ'  => 't',
					'ր'  => 'r',
					'ց'  => 'c',
					'ւ'  => 'w',
					'փ'  => 'p',
					'ք'  => 'q',
					'օ'  => 'o',
					'ֆ'  => 'f',
					'ու' => 'u',
					'և'  => 'ew',
			);
		
			public function __construct() {
				$this->CYRTOL_conversationHY();
				}
			
			private function CYRTOL_conversationHY() {
				$filters = [
					'gettext',
					'gettext_with_context',
					'ngettext',
					'ngettext_with_context',
				];
			
				foreach ($filters as $filter) {
					add_filter($filter, [$this, 'CYRTOL_translationHY'], 9);
				}
			}
        
			function CYRTOL_translationHY ( $languageHY ) {
		
				return strtr( $languageHY, $this->armenian );
		
						}
		
			function CYRTOL_HY2Lat() {
				$this->CYRTOL_conversationHY();
			}
		
		
		}
		$HY2Lat = new CYRTOL_HY2Lat;
		}	

		/* GEORGIAN */
	if (get_locale() == 'ka_GE') {
		class CYRTOL_GE2Lat {
		
			public $georgian = array(
				    'ა' => 'a',
					'ბ' => 'b',
					'გ' => 'g',
					'დ' => 'd',
					'ე' => 'e',
					'ვ' => 'v',
					'ზ' => 'z',
					'ჱ' => '',
					'თ' => 'th',
					'ი' => 'i',
					'კ' => 'k',
					'ლ' => 'l',
					'მ' => 'm',
					'ნ' => 'n',
					'ჲ' => '',
					'ო' => 'o',
					'პ' => 'p',
					'ჟ' => 'zh',
					'რ' => 'r',
					'ს' => 's',
					'ტ' => 't',
					'ჳ' => '',
					'უ' => 'u',
					'ფ' => 'ph',
					'ქ' => 'kh',
					'ღ' => 'gh',
					'ყ' => 'qh',
					'შ' => 'sh',
					'ჩ' => 'ch',
					'ც' => 'ts',
					'ძ' => 'dz',
					'წ' => 'c',
					'ჭ' => 'ch',
					'ხ' => 'kh',
					'ჴ' => '',
					'ჯ' => 'j',
					'ჰ' => 'h',
					'ჵ' => '',
			);
		
			public function __construct() {
				$this->CYRTOL_conversationGE();
				}
			
			private function CYRTOL_conversationGE() {
				$filters = [
					'gettext',
					'gettext_with_context',
					'ngettext',
					'ngettext_with_context',
				];
			
				foreach ($filters as $filter) {
					add_filter($filter, [$this, 'CYRTOL_translationGE'], 9);
				}
			}
		
			function CYRTOL_translationGE ( $languageGE ) {
		
				return strtr( $languageGE, $this->georgian );
		
						}
		
			function CYRTOL_GE2Lat() {
				$this->CYRTOL_conversationGE();
			}
		
		
		}
		$GE2Lat = new CYRTOL_GE2Lat;
		}	
		
/* KAZAKH */
if (get_locale() == 'kK') {
	class CYRTOL_KK2Lat {
	
		public $kazakh = array(
			'А' => 'A',
				'Ә' => 'Ae',
				'Б' => 'B',
				'В' => 'V',
				'Г' => 'G',
				'Ғ' => 'Gh',
				'Д' => 'D',
				'Е' => 'E',
				'Ё' => 'YO',
				'Ж' => 'ZH',
				'З' => 'Z',
				'И' => 'I',
				'Й' => 'J',
				'К' => 'K',
				'Қ' => 'Q',
				'Л' => 'L',
				'М' => 'M',
				'Н' => 'N',
				'Ң' => 'Ng',
				'О' => 'O',
				'Ө' => 'Oe',
				'П' => 'P',
				'Р' => 'R',
				'С' => 'S',
				'Т' => 'T',
				'У' => 'W',
				'Ұ' => 'U',
				'Ү' => 'Ue',
				'Ф' => 'F',
				'Х' => 'H',
				'Һ' => 'H',
				'Ц' => 'C',
				'Ч' => 'CH',
				'Ш' => 'SH',
				'Щ' => 'SHH',
				'Ъ' => '',
				'Ы' => 'Y',
				'І' => 'I',
				'Ь' => '',
				'Э' => 'E',
				'Ю' => 'YU',
				'Я' => 'YA',
				'а' => 'a',
				'ә' => 'ae',
				'б' => 'b',
				'в' => 'v',
				'г' => 'g',
				'ғ' => 'gh',
				'д' => 'd',
				'е' => 'e',
				'ё' => 'yo',
				'ж' => 'zh',
				'з' => 'z',
				'и' => 'i',
				'й' => 'j',
				'к' => 'k',
				'қ' => 'q',
				'л' => 'l',
				'м' => 'm',
				'н' => 'n',
				'ң' => 'ng',
				'о' => 'o',
				'ө' => 'oe',
				'п' => 'p',
				'р' => 'r',
				'с' => 's',
				'т' => 't',
				'у' => 'w',
				'ұ' => 'u',
				'ү' => 'ue',
				'ф' => 'f',
				'х' => 'h',
				'һ' => 'h',
				'ц' => 'c',
				'ч' => 'ch',
				'ш' => 'sh',
				'щ' => 'shh',
				'ъ' => '',
				'ы' => 'y',
				'і' => 'i',
				'ь' => '',
				'э' => 'e',
				'ю' => 'yu',
				'я' => 'ya',
				// Kazakh 2018 latin.
				'Á' => 'A',
				'Ǵ' => 'G',
				'I' => 'I',
				'Ń' => 'N',
				'Ó' => 'O',
				'Ú' => 'O',
				'Ý' => 'O',
				'á' => 'a',
				'ǵ' => 'g',
				'ı' => 'i',
				'ń' => 'n',
				'ó' => 'o',
				'ú' => 'o',
				'ý' => 'o',
		);
	
		public function __construct() {
			$this->CYRTOL_conversationKK();
			}
		
		private function CYRTOL_conversationKK() {
			$filters = [
				'gettext',
				'gettext_with_context',
				'ngettext',
				'ngettext_with_context',
			];
		
			foreach ($filters as $filter) {
				add_filter($filter, [$this, 'CYRTOL_translationKK'], 9);
			}
		}
	
		function tCYRTOL_ranslationKK ( $languageKK ) {
	
			return strtr( $languageKK, $this->kazakh );
	
					}
	
		function CYRTOL_KK2Lat() {
			$this->CYRTOL_conversationKK();
		}
	
	
	}
	$KK2Lat = new CYRTOL_KK2Lat;
	}	